		function [R, K, RL] = RICHARDS_REACTANCE_S(Znum, Zden)
		
		% 	Computes the characteristic impedances in a Richards' structure   
		%	consisting of cascaded lossless commensurate transmission lines 
		%	for an impedance Z = Znum/Zden, where Znum and Zden are polynomials 
		%	in S, where S is Richards' variable. For example, Znum = [3 2 1]
		%	correspond to Znum = 3S^2 + 2S + 1.
		%	The last transmission line is either open-circuited, 
		%	short-circuited, or resistively terminated with RL.
		%
		%	The vector Z contains the characteristic impedances for the  
		%	transmission lines. The termination, RL, is given separately.	 
		%	K is a vector used by LADDER_2_H that defines the two-ports.
 
		% 	Toolbox for DIGITAL FILTERS USING MATLAB
		
		% 	Author: 			Lars Wanhammar, 2008-11-17
		% 	Modified by: 	 	LW 2009-09-01
		%	Copyright:			by authors - not released for commercial use
		% 	Version:			1 
		% 	Known bugs:			
		% 	Report bugs to:		Wanhammar@gmail.com
		
		%	 Check if the reactance is terminated resistively, open-circuited, or short-circuited.
		X = Znum(end);
		Y = Zden(end);
		if X == 0
			RL = 0;
		end
		if Y == 0
			RL = inf;
		end
		if X ~= 0 & Y ~= 0
			RL = X/Y;
		end
		Nnum = length(Znum); Nden = length(Zden);
		N = max(Nnum, Nden);
		if mod(N, 2) == 1			% Make all vectors of equal length
			if Nden > Nnum
				Nnum = [0, Nnum];
			else
				Nden = [0, Nden];	% Nnum > Nden
			end
		else	% N = even
			if Nnum > Nden
				Nden = [0, Nden];
			else
				Nnum = [0, Nnum];	% Nnum < Nden
			end
		end		
		R = []; 
		a = fliplr(Znum); 
		b = fliplr(Zden); 
		for k = 1:length(b)-1
			R0 = sum(a)/sum(b);
			for j = 2:length(b)
				a(j) = a(j) - R0*b(j-1);
				b(j) = b(j) - a(j-1)/R0;
			end
			R = [R, R0];
			K(k) = 6;
		end
		
